﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;
using VIA = VIRP_WEB.ViaServices;

namespace VIRP_WEB.Common
{
    public partial class NoteTemplatePreview : BasePage
    {
        protected bool isconsultnotetitle = false;
        private NotesManager notesManager;

        private SURVEYS SURVEY
        {
            get
            {
                SURVEYS survey = null;

                if (ViewState["SURVEY"] != null)
                {
                    survey = ViewState["SURVEY"] as SURVEYS;
                }
                else
                {
                    int surveysId = 0;

                    if (!string.IsNullOrEmpty(hideSurveyId.Value))
                        int.TryParse(hideSurveyId.Value.ToString(), out surveysId);
                    else
                    {
                        surveysId = UserSession.CurrentSurveyId;
                        hideSurveyId.Value = UserSession.CurrentSurveyId.ToString();
                    }

                    if (surveysId > 0)
                        survey = ServiceInterfaceManager.SURVEYS_GET_FOR_SURVEY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, surveysId);

                    ViewState["SURVEY"] = survey;
                }

                return survey;
            }
            //DNS - unused method
            //set
            //{
            //    ViewState["SURVEY"] = value;
            //}
        }

        private List<SURVEY_RESULTS> RESULTS
        {
            get
            {
                List<SURVEY_RESULTS> results = null;

                if (ViewState["RESULTS"] != null)
                {
                    results = ViewState["RESULTS"] as List<SURVEY_RESULTS>;
                }
                else
                {
                    int surveysId = 0;

                    if (!string.IsNullOrEmpty(hideSurveyId.Value))
                        int.TryParse(hideSurveyId.Value.ToString(), out surveysId);
                    else
                    {
                        surveysId = UserSession.CurrentSurveyId;
                        hideSurveyId.Value = UserSession.CurrentSurveyId.ToString();
                    }

                    if (surveysId > 0)
                        results = ServiceInterfaceManager.SURVEY_RESULTS_GET_ALL_BY_SURVEY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, surveysId);

                    ViewState["RESULTS"] = results;
                }

                return results;
            }
            //DNS - unused method
            //set
            //{
            //    ViewState["RESULTS"] = value;
            //}
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            notesManager = new NotesManager();

            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);

                lblResult.Text = string.Empty;

                if (UserSession == null || UserSession.CurrentRegistryId <= 0)
                {
                    Response.Redirect("~/Default.aspx", false);
                }
                else if (UserSession.CurrentSurveyId <= 0)
                {
                    Response.Redirect("~/Common/Surveys.aspx", false);
                }
                else
                {
                    if (ServiceInterfaceManager.USER_ROLES_GET_BY_REGISTRYID_USERNAME_SET_READONLY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId))
                    {
                        SetReadOnly();
                    }
                    if (!Page.IsPostBack)
                    {
                        //BuildCommonMenu();

                        SetupForm();
                    }

                    notesManager.PatientCprsLoad();
                    SetupNoteSelections();
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void SetReadOnly()
        {
            lblResult.Text = "You are not able to edit information on this page.<br /><br />";
            ButtonContinue.Visible = false;
        }

        protected void BtnCancel_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                UserSession.CurrentSurveyId = 0;
                Response.Redirect("~/Common/Surveys.aspx", false);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void SetupNoteSelections()
        {
            ErrorPanel.Visible = false;

            if (notesManager.ViaData != null)
            {
                PATIENT p = ServiceInterfaceManager.PATIENT_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, UserSession.CurrentPatientId);
                if (p != null)
                {
                    if (notesManager.ViaData.PatientICN != p.PatientICN)
                    {
                        PanelObjectContent.Visible = false;
                        pnlPatientNoMatch.Visible = true;
                        pnlPatientMatch.Visible = false;
                        return;
                    }
                    else
                    {
                        pnlPatientNoMatch.Visible = false;
                        pnlPatientMatch.Visible = true;
                    }
                }
            }

            if (!IsPostBack)
            {
                RadioButtonListEncounterType.SelectedIndex = -1;
                TableRowClinicAppointment.Visible = false;
                TableRowHospitalAdmission.Visible = false;
                TableRowUnscheduledNewVisitLocation.Visible = false;
                TableRowCosigner.Visible = false;

                //populate consult drop down list 
                string errorMessage = "";

                try
                {
                    //populate note title drop down list
                    List<VIA.StringKeyValuePair> titles = null;
                    if (notesManager != null)
                    {
                        if (txtNoteSearchFilter.Text == "")
                        {
                            titles = notesManager.GetNoteTitlesFromVIA("", "", out errorMessage);
                        }
                        else
                        {
                            titles = notesManager.GetNoteTitlesFromVIA("" + txtNoteSearchFilter.Text + "", "", out errorMessage);
                            txtNoteSearchFilter.Text = "";
                        }

                        if (errorMessage == "SUCCESS")
                        {
                            errorMessage = null;
                        }

                        if (String.IsNullOrEmpty(errorMessage))
                        {
                            DropDownListNoteTitleId.DataSource = titles;
                            DropDownListNoteTitleId.DataBind();
                        }
                        else
                        {
                            PanelObjectContent.Visible = false;
                            ErrorPanel.Visible = true;

                            CallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                            return;
                        }
                    }
                    else
                    {
                        titles = null;
                    }

                    int consultCount = 0;
                    List<VIA.StringKeyValuePair> consults;
                    if (notesManager != null)
                    {
                        consults = notesManager.GetConsultsFromVIA(out errorMessage); //try passing noteid as paramter
                                                                                              //_consultCount = _notesManager.getConsultsFromVIA(out errorMessage).Count;

                        if (consults != null) { consultCount = consults.Count; }

                        if (errorMessage == "SUCCESS")
                        {
                            errorMessage = null;
                        }

                        if (String.IsNullOrEmpty(errorMessage))
                        {
                            DropDownListConsult.DataSource = consults;
                            DropDownListConsult.DataBind();
                        }
                        else
                        {
                            //display error message and stop processing
                            PanelObjectContent.Visible = false;
                            ErrorPanel.Visible = true;

                            return;
                        }

                        if (consultCount == 0)
                        {
                            LabelforDropDownListConsult.Visible = false;
                            DropDownListConsult.Visible = false;
                            RequiredFieldValidatorDropDownListConsult.Enabled = false;
                        }
                        else
                        {
                            LabelforDropDownListConsult.Visible = true;
                            DropDownListConsult.Visible = true;
                            RequiredFieldValidatorDropDownListConsult.Enabled = true;
                            LabelforDropDownListConsult.Text = "Link to Consult:";
                            LabelforDropDownListConsult.Font.Bold = true;
                        }
                    }
                    else
                    {
                        consults = null;
                    }
                }
                catch (Exception ex)
                {
                    PanelObjectContent.Visible = false;
                    ErrorPanel.Visible = true;
                    ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                }
            }

            if (notesManager.ViaData != null)
            {
                LabelPatient.Text = AntiXssEnc.Encoder.HtmlEncode(notesManager.ViaData.PatientName);
            }
        }

        private void SetupForm()
        {
            tblForm.Visible = false;

            viewPatient.LoadForm(UserSession.CurrentPatientId);

            SURVEYS survey = SURVEY;
            if (survey != null)
            {
                tblForm.Visible = true;

                if (survey.STD_SURVEY_TYPE != null)
                {
                    lblPageTitle.Text = AntiXssEnc.Encoder.HtmlEncode(survey.STD_SURVEY_TYPE.NAME);
                    txtNoteTemplate.Text += lblPageTitle.Text + Environment.NewLine + Environment.NewLine;
                }

                List<SURVEY_RESULTS> results = RESULTS;
                if (results != null)
                {
                    //Select distinct question ids
                    List<Int32> questionIds = results.Select(data => data.STD_QUESTION_ID).Distinct().ToList();
                    if (questionIds != null && questionIds.Count > 0)
                    {
                        bool showCommentBox = false;
                        bool showSeparator = true;

                        foreach (Int32 questionId in questionIds)
                        {
                            List<SURVEY_RESULTS> questions = results.Where(data => data.STD_QUESTION_ID == questionId).ToList();
                            if (questions != null && questions.Count > 0)
                            {
                                Label lbl = new Label();

                                //Add question number and text to table
                                STD_QUESTION stdQuestion = questions.First().STD_QUESTION;
                                if (stdQuestion != null)
                                {
                                    if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.MultipleChoice)
                                    {
                                        //Multiple Choice
                                        showCommentBox = true;
                                        showSeparator = true;

                                        var control = (Controls.Survey.SurveyQuestionMultipleChoice)LoadControl("~/Controls/Survey/SurveyQuestionMultipleChoice.ascx");
                                        control.Questions = questions;
                                        string note = control.BuildNoteTemplate();
                                        txtNoteTemplate.Text += note;
                                    }
                                    else if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.Scale)
                                    {
                                        showCommentBox = true;
                                        showSeparator = true;

                                        var control = (Controls.Survey.SurveyQuestionScale)LoadControl("~/Controls/Survey/SurveyQuestionScale.ascx");
                                        control.Questions = questions;
                                        string note = control.BuildNoteTemplate();
                                        txtNoteTemplate.Text += note;
                                    }
                                    else if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.Description)
                                    {
                                        //Description
                                        showCommentBox = false;
                                        showSeparator = false;

                                        var control = (Controls.Survey.SurveyQuestionDescription)LoadControl("~/Controls/Survey/SurveyQuestionDescription.ascx");
                                        control.Questions = questions;
                                        string note = control.BuildNoteTemplate();
                                        txtNoteTemplate.Text += note;
                                    }
                                    else if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.FreeText)
                                    {
                                        //Free Text
                                        showCommentBox = true;
                                        showSeparator = true;

                                        var control = (Controls.Survey.SurveyQuestionFreeText)LoadControl("~/Controls/Survey/SurveyQuestionFreeText.ascx");
                                        control.Questions = questions;
                                        string note = control.BuildNoteTemplate();

                                        txtNoteTemplate.Text += note;
                                    }
                                    else if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.Calculation)
                                    {
                                        showCommentBox = false;
                                        showSeparator = true;

                                        var control = (Controls.Survey.SurveyQuestionCalculation)LoadControl("~/Controls/Survey/SurveyQuestionCalculation.ascx");
                                        control.Questions = questions;
                                        string note = control.BuildNoteTemplate();

                                        txtNoteTemplate.Text += note;
                                    }

                                    #region Add Comment TextBox
                                    if (showCommentBox)
                                    {
                                        StringBuilder sbNote = new StringBuilder();
                                        string strComment = questions[0].COMMENTS_TEXT;
                                        if (!string.IsNullOrWhiteSpace(strComment))
                                        {
                                            sbNote.AppendLine("Comments: " + strComment);
                                            txtNoteTemplate.Text += sbNote.ToString();
                                        }
                                    }
                                    #endregion

                                    if (showSeparator)
                                    {
                                        txtNoteTemplate.Text += Environment.NewLine;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        private void FilterAndBindVisits()
        {
            //populate Appointments drop down list
            DateTime toDate = new DateTime();
            DateTime fromDate = new DateTime();
            string errorMessage = "";

            if (TextBoxAppointmentSearchDateStart.Text != "")
            {
                fromDate = DateTime.Parse(TextBoxAppointmentSearchDateStart.Text);
            }
            else
            {
                //if user does not enter a date then default to 30 days prior
                if (TextBoxAppointmentSearchDateEnd.Text == "")
                {
                    fromDate = System.DateTime.Now.AddDays(-30);
                }
                else
                {
                    fromDate = DateTime.Parse(TextBoxAppointmentSearchDateEnd.Text).AddDays(-30);
                }
            }

            if (TextBoxAppointmentSearchDateEnd.Text != "")
            {
                toDate = DateTime.Parse(TextBoxAppointmentSearchDateEnd.Text);
            }
            else
            {
                //if user does not enter a date then default to 30 in future
                if (TextBoxAppointmentSearchDateStart.Text == "")
                {
                    toDate = System.DateTime.Now.AddDays(30);
                }
                else
                {
                    toDate = DateTime.Parse(TextBoxAppointmentSearchDateStart.Text).AddDays(30);
                }
            }

            try
            {
                var visits = new List<VIA.StringKeyValuePair>();

                visits = notesManager.GetVisitsFromVIA(fromDate, toDate, out errorMessage);

                if (errorMessage == "SUCCESS")
                {
                    errorMessage = null;
                }

                if (String.IsNullOrEmpty(errorMessage))
                {
                    DropDownListScheduledClinicAppointment.ClearSelection();
                    DropDownListScheduledClinicAppointment.Items.Clear();
                    DropDownListScheduledClinicAppointment.Items.Add(new ListItem("-- Select a Value --", "0"));

                    //DropDownListScheduledClinicAppointment.DataSource = _notesManager.getVisits(fromDate.GetValueOrDefault(), toDate.GetValueOrDefault());
                    DropDownListScheduledClinicAppointment.DataSource = visits;

                    DropDownListScheduledClinicAppointment.DataBind();
                }
                else
                {
                    PanelObjectContent.Visible = false;
                    ErrorPanel.Visible = true;

                    return;
                }
            }
            catch (Exception ex)
            {
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
        }

        private void FilterAndBindLocations()
        {
            //populate location drop down list
            //DropDownListUnscheduleNewVisitLocation.DataSource = _notesManager.getLocations(TextBoxLocationSearchString.Text, "", "1");
            string errorMessage = "";

            var locations = new List<VIA.StringKeyValuePair>();

            locations = notesManager.GetLocationsFromVIA(TextBoxLocationSearchString.Text, "1", out errorMessage);

            try
            {
                if (errorMessage == "SUCCESS")
                {
                    errorMessage = null;
                }

                if (String.IsNullOrEmpty(errorMessage))
                {
                    DropDownListUnscheduleNewVisitLocation.ClearSelection();
                    DropDownListUnscheduleNewVisitLocation.Items.Clear();
                    DropDownListUnscheduleNewVisitLocation.Items.Add(new ListItem("-- Select a Value --", "0"));

                    DropDownListUnscheduleNewVisitLocation.DataSource = locations;
                    DropDownListUnscheduleNewVisitLocation.DataBind();
                }
                else
                {
                    PanelObjectContent.Visible = false;
                    ErrorPanel.Visible = true;

                    return;
                }
            }
            catch (Exception ex)
            {
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                CallError.Text = ex.Message;
            }
        }

        protected void RadioButtonListEncounterType_SelectedIndexChanged(object sender, EventArgs e)
        {
            ButtonContinue.Visible = false;

            TableRowClinicAppointment.Visible = false;
            TableRowHospitalAdmission.Visible = false;
            TableRowUnscheduledNewVisitLocation.Visible = false;

            int encounterTypeSelected =
            Helpers.GetIntFromString(RadioButtonListEncounterType.SelectedValue);

            string errorMessage = "";

            if (encounterTypeSelected != (int)NoteTypeEnum.ScheduledClinicAppointment)
            {
                TextBoxAppointmentSearchDateStart.Text = "";
                TextBoxAppointmentSearchDateEnd.Text = "";
            }

            switch (encounterTypeSelected)
            {
                case (int)NoteTypeEnum.ScheduledClinicAppointment:  //Scheduled Clinic Appointment
                    TableRowClinicAppointment.Visible = true;

                    FilterAndBindVisits();

                    break;

                case (int)NoteTypeEnum.HospitalAdmission:  //Hospital Admission
                    TableRowHospitalAdmission.Visible = true;

                    //populate hospital admission drop down list
                    try
                    {
                        var admissions = new List<VIA.StringKeyValuePair>();

                        admissions = notesManager.GetHospitalAdmissionsFromVIA(out errorMessage);

                        if (errorMessage == "SUCCESS")
                        {
                            errorMessage = null;
                        }

                        if (String.IsNullOrEmpty(errorMessage))
                        {
                            DropDownListHospitalAdmission.DataSource = admissions;
                            DropDownListHospitalAdmission.DataBind();
                        }
                        else
                        {
                            PanelObjectContent.Visible = false;
                            ErrorPanel.Visible = true;

                            CallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                            return;
                        }
                    }
                    catch (Exception ex)
                    {
                        PanelObjectContent.Visible = false;
                        ErrorPanel.Visible = true;
                        ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

                        CallError.Text = ex.Message;
                    }
                    break;

                case (int)NoteTypeEnum.CurrentStay:  //Current Stay

                    if (string.IsNullOrEmpty(notesManager.ViaData.PatientLocationId) || string.IsNullOrEmpty(notesManager.ViaData.PatientAdmitTimeStamp))
                    {
                        ErrorPanel.Visible = true;
                        CallError.Text = "This patient does not have a current stay available, please select a different Encounter Type";
                        RadioButtonListEncounterType.ClearSelection();
                    }

                    break;

                case (int)NoteTypeEnum.UnscheduledOrNewVisit: //Unscheduled or New Visit
                    TableRowUnscheduledNewVisitLocation.Visible = true;

                    FilterAndBindLocations();

                    break;
            }

            ButtonContinue.Visible = true;
        }

        protected void Filter_NoteSearch(object sender, EventArgs e)
        {
            //Get the text from text box

            //Preview the text and show it in Div
            string errorMessage = "";
            try
            {
                if (IsPostBack)
                {
                    object titles = null;

                    string filter_text = null;
                    if (notesManager != null)
                    {
                        //filter_text = ((TextBox)sender).Text;
                        filter_text = txtNoteSearchFilter.Text;
                        if (filter_text != null)
                        {
                            if (DropDownListNoteTitleId.Items.Count > 0)
                            {
                                DropDownListNoteTitleId.Items.Clear();
                                DropDownListNoteTitleId.Items.Add(new ListItem("-- Select a Value --", "0"));
                            }

                            titles = notesManager.GetNoteTitlesFromVIA("" + filter_text + "", "", out errorMessage);

                            if (errorMessage == "SUCCESS")
                            {
                                errorMessage = null;
                            }

                            if (String.IsNullOrEmpty(errorMessage))
                            {
                                DropDownListNoteTitleId.DataSource = titles;
                                DropDownListNoteTitleId.DataBind();
                            }
                            else
                            {
                                PanelObjectContent.Visible = false;
                                ErrorPanel.Visible = true;

                                CallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                                return;
                            }
                        }
                    }
                    else
                    {
                        titles = null;
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void DropDownListNoteTitleId_SelectedIndexChanged(object sender, EventArgs e)
        {
            string errorMessage = "";
            string notetitle = "";

            try
            {
                if (DropDownListNoteTitleId.SelectedValue != "0")
                {
                    notesManager.ViaData.SelectedNoteTitleId = DropDownListNoteTitleId.SelectedValue;

                    bool needCosigner = false;

                    //if (getCurrentServiceToUse() == "VIA")
                    //{
                    //    needCosigner = _notesManager.isCosignerRequiredVIA(_notesManager.TbiServiceTo, out errorMessage);
                    //}
                    //else
                    //{
                    //    needCosigner = _notesManager.isCosignerRequired(_notesManager.TbiServiceTo, out errorMessage);
                    //}

                    if (errorMessage == "SUCCESS")
                    {
                        errorMessage = null;
                    }

                    if (String.IsNullOrEmpty(errorMessage))
                    {
                        if (DropDownListNoteTitleId.SelectedItem != null)
                        {
                            notetitle = DropDownListNoteTitleId.SelectedItem.Text.ToString().ToUpper();

                            isconsultnotetitle = notetitle.Contains("CONSULT");
                        }

                        if (needCosigner)
                        {
                            ButtonContinue.Visible = false;

                            TableRowCosigner.Visible = true;

                            //FilterAndBindCosigners();

                            ButtonContinue.Visible = true;
                        }
                        else
                        {
                            TableRowCosigner.Visible = false;
                        }

                        if (isconsultnotetitle == true)
                        {
                            LabelforDropDownListConsult.Visible = true;
                            DropDownListConsult.Visible = true;
                            LabelforDropDownListConsult.Text = "Link to Consult *:";
                            LabelforDropDownListConsult.Font.Bold = true;
                            DropDownListConsult.SelectedIndex = 0;
                            RequiredFieldValidatorDropDownListConsult.Enabled = true;
                        }
                        else
                        {
                            LabelforDropDownListConsult.Visible = false;
                            DropDownListConsult.Visible = false;
                            RequiredFieldValidatorDropDownListConsult.Enabled = false;
                        }
                    }
                    else
                    {
                        PanelObjectContent.Visible = false;
                        ErrorPanel.Visible = true;

                        CallError.Text = errorMessage;
                    }
                }
                else
                {
                    TableRowCosigner.Visible = false;
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void ButtonFilterAppointments_Click(object sender, EventArgs e)
        {
            FilterAndBindVisits();
        }

        protected void ButtonGetLocations_Click(object sender, EventArgs e)
        {
            FilterAndBindLocations();
        }

        protected void ButtonGetCPRSUsers_Click(object sender, EventArgs e)
        {
            //FilterAndBindCosigners();
        }

        protected void ButtonContinue_Click(object sender, EventArgs e)
        {
            try
            {
                if (DropDownListCosigner.SelectedValue != "0")
                {
                    notesManager.ViaData.SelectedCosignerID = DropDownListCosigner.SelectedValue;
                }

                if (DropDownListNoteTitleId.SelectedValue != "0")
                {
                    notesManager.ViaData.SelectedNoteTitleId = DropDownListNoteTitleId.SelectedValue;
                }

                if (DropDownListConsult.SelectedValue != "0")
                {
                    notesManager.ViaData.SelectedConsultId = DropDownListConsult.SelectedValue;
                }

                if (DropDownListScheduledClinicAppointment.SelectedValue != "0")
                {
                    notesManager.ViaData.SelectedVisitId = DropDownListScheduledClinicAppointment.SelectedValue;
                }

                if (DropDownListHospitalAdmission.SelectedValue != "0")
                {
                    notesManager.ViaData.SelectedHospitalAdmissionId = DropDownListHospitalAdmission.SelectedValue;
                }

                if (DropDownListUnscheduleNewVisitLocation.SelectedValue != "0")
                {
                    notesManager.ViaData.SelectedLocationID = DropDownListUnscheduleNewVisitLocation.SelectedValue;
                }

                notesManager.ViaData.IsHistorical = CheckBoxUnscheduledNewVisitHistorical.Checked;

                if (RadioButtonListEncounterType.SelectedIndex != -1)
                {
                    NoteType selectedNoteType = new NoteType();
                    selectedNoteType.Id = RadioButtonListEncounterType.SelectedIndex;

                    notesManager.ViaData.SelectedNoteType = selectedNoteType;
                }

                //notesManager.AddToSessionViaData(notesManager.ViaData);
                ////ViaServiceData viaData = notesManager.GetViaDataFromSession();
                //ViaServiceData viaData = notesManager.ViaData;
                //notesManager.AddToSessionViaData(viaData);

                notesManager.ViaData.NoteText = txtNoteTemplate.Text;

                if (notesManager.ViaData != null)
                {
                    //Logging.WriteLogToFile("VIA submission-Text: " + viaData.NoteText);

                    // VIA

                    //notesManager.LoadViaData(viaData);
                    notesManager.LoadViaData();

                    //VIA.noteResultTO result = null;
                    //result = notesManager.WriteNoteWithVIA(viaData);
                    //result = notesManager.WriteNoteWithVIA();
                    notesManager.WriteNoteWithVIA();

                    lblResult.Text = "Note has been successfully uploaded to CPRS.";

                    //if (_result.fault == null)
                    //{
                    //    survey = Session["survey"] as SURVEY;
                    //    if (survey != null)
                    //    {
                    //        survey.SetAsChangeTrackingRoot();
                    //        survey.SURVEY_STATUS = "completed";

                    //        SURVEY_NOTE note = new SURVEY_NOTE();

                    //        note.NOTES_TEXT = viaData.NoteText;
                    //        note.ENTRY_DATE = DateTime.Today;
                    //        note.NOTE_DATE = DateTime.Today;
                    //        note.STD_INSTITUTION_ID = 1000001;
                    //        survey.SURVEY_NOTEs.Add(note);

                    //        _notesManager.Update(survey);
                    //        //SubmitNoteButton.Enabled = false;
                    //    }

                    //    Session.Remove("survey");

                    //    Logging.WriteLogToFile("Completed note submission and writing survey data");

                    //    string script = "<script language=\"javascript\"  type=\"text/javascript\">window.open('','_self','');window.close();</script>";
                    //    ScriptManager.RegisterStartupScript(Page, this.GetType(), "closePage", script, false);
                    //}
                    //else
                    //{

                    //    Logging.WriteLogToFile("Error submitting note: " + _result.fault.message);

                    //    SurveyNoteError.Text = "Error: " + _result.fault.message;
                    //    ErrorPanel.Visible = true;
                    //    //ButtonsPanel.Visible = false;
                    //    //SurveyNoteHTML.Visible = false;
                    //}
                }
                //}
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
        }
    }
}